#!/bin/env ruby
# encoding: utf-8
require 'rubygems'
require 'rspec'
require 'watir-webdriver'
require 'page-object'
require 'oci8'

require_relative '../../module/DriverUtility'
require_relative '../rspec_helper'
require_relative 'request_helper'
require_relative '../../pages/landing'
require_relative '../../pages/login'
require_relative '../../pages/eula'
require_relative '../../common/common'
require_relative '../../pages/landing_appointments'
require_relative '../../pages/appointments/new_appointment_request'
require_relative '../../pages/appointments/request_appointment_detail'
require_relative '../../helper/modal'
require_relative '../../module/database/OracleUtility'
require_relative '../../module/DateUtility'
require_relative '../../helper/error_validation'
require_relative '../../module/database/MongoUtility'


describe '[Story #VAR-1945: New Request - Submission/Cancel Entry]' do
  include OracleUtility
  include DateUtility
  include DriverUtility
  include MongoUtility

  before(:all) do
    initializeConfigurations(VAR_BASE_URL)
    @landing_appointments = LandingAppointments.new(@driver)
    @login = Login.new(@driver)
    @eula = Eula.new(@driver)
    @common = Common.new(@driver)
    @modal = Modal.new(@driver)
    @new_request = NewAppointmentRequest.new(@driver)
    @detail = RequestAppointmentDetail.new(@driver)
    @error = Error_Validation.new(@driver)
    TITLE = "Appointments/Requests"

    #mongo
    @db = connectToMongoDB("var-utility")
    restoreCollection("siteSupportingVAR", "var-utility", "sites-supporting-var-exported2.json", @db)
    restoreCollection("clinical-services", "var-utility", "clinical_services_default.json", @db)
    restoreCollection("custom-friendly-text", "var-utility", "facility_friendly_name.json", @db)
    restoreCollection("requestEligibilityCriteria", "var-utility", "requestEligibilityCriteria.json", @db)
    restoreCollection("directBookingEligibilityCriteria", "var-utility", "directSchedulingEnabled.json", @db)

    @today = getDateNthDaysFromNow(0, "%m/%d/%Y")

    @fiveDaysLater = getDateNthDaysFromNow(5, "%m/%d/%Y")
    @nintyDaysLater = getDateNthDaysFromNow(90, "%m/%d/%Y")

    #this will not work in CI but the data will be reset in the jenkins
    @patientID = "1006088937V099668"
    @patientID2 = "1113138327"
    deletePatientData(@patientID)
    deletePatientData(@patientID2)
    @@locationID="523A5"
    @@locationName="BROCKTON VAMC"
    @@typeOfCare = MENTAL_HEALTH
    @@friendlyName ="Facility Friendly Text"
    @@facilityName = "BOSTON HCS VAMC"
    @@new_message_50 = "01234567890123456789012345678901234567890123456789"
    @common.loginEndsOnHome(pw_redacted)
  end

  after(:all) do
    @driver.close
  end

  context "AC#VAR-2480|TC#VAR-2517: New Request - Submission Confirmation Criteria" do

    it "Add a mental health request and verify details" do
      schedulingMethod = "clerk"
      facilityId = "523"

      typeOfVisit = "Office Visit"
      purposeOfVisit = "New Issue"
      otherPurposeOfVisit = ""
      desiredDateTime1 = [getDateNthDaysFromNow(30, "%m/%d/%Y"), "AM"]
      desiredDateTime2 = [getDateNthDaysFromNow(32, "%m/%d/%Y"), "PM"]
      desiredDAteTime3 = [getDateNthDaysFromNow(33, "%m/%d/%Y"), "AM"]
      phoneNum = "(234) 567-8901"
      verifyPhoneNum = "(234) 567-8901"

      bestTimeToCall = " Evening"
      call_morning = false
      call_afternoon = false
      call_evening = true
      bestTimesForVAtoCall = [call_morning, call_afternoon, call_evening]
      vaToCallYou = false
      message = "Requesting Mental Health Appointment"
      sendMeEmail = "false"
      email = "test1@hotmail.com"
      addRequest(schedulingMethod, @@typeOfCare, facilityId, typeOfVisit, purposeOfVisit, otherPurposeOfVisit, desiredDateTime1, desiredDateTime2, desiredDAteTime3, phoneNum, verifyPhoneNum, bestTimesForVAtoCall, vaToCallYou, message, sendMeEmail, email  )

      expected_details = [\
        "Request Details",
        "Submitted: " + @today + " @ HH:MM" + " Location: " + @@facilityName + " Type of Care: " + @@typeOfCare + " Preferred Type of Visit: " + typeOfVisit,
        "Purpose of Visit: " + purposeOfVisit,
        "Preferred Appointment Date/Time",
        "1st Choice: " + desiredDateTime1[0] + " " + desiredDateTime1[1] + " 2nd Choice: " + desiredDateTime2[0] + " " + desiredDateTime2[1] + " 3rd Choice: " + desiredDAteTime3[0] + " " + desiredDAteTime3[1]
      ]
      expected_communicating_with_clerk= [\
           "Message a Scheduling Clerk",
           "You may send up to two (2) messages while this request is in Submitted status. If you need additional information, please call your local VA Medical Center"

      ]
      verifyRequestDetails(expected_details, expected_communicating_with_clerk, @@facilityName)

    end


    it "Verify Request in list" do
      verifyTableList(@@facilityName, @today, @@typeOfCare)
    end
      #add 2nd Mental Health Request

    it "add a second mental health request" do
      #add clerk Mental Health
      schedulingMethod = "clerk"

      facilityId = "523"
      typeOfVisit = "Phone Call"
      purposeOfVisit = "New Issue"
      otherPurposeOfVisit = ""
      desiredDateTime1 = [getDateNthDaysFromNow(88, "%m/%d/%Y"), "PM"]
      desiredDateTime2 = [getDateNthDaysFromNow(89, "%m/%d/%Y"), "PM"]
      desiredDAteTime3 = [getDateNthDaysFromNow(90, "%m/%d/%Y"), "AM"]
      phoneNum = "(571) 234-8901"
      verifyPhoneNum = "(571) 234- 8901"

      bestTimeToCall = "Evening"
      call_morning = false
      call_afternoon = false
      call_evening = true

      bestTimesForVAtoCall = [call_morning, call_afternoon, call_evening]
      vaToCallYou = false
      message = ""
      sendMeEmail = "true"
      email = "test2@hotmail.com"
      @landing_appointments.primary_header_element.when_present(TIME_OUT_LIMIT)
      waitTillRequestsDisplay
      addRequest(schedulingMethod, @@typeOfCare, facilityId, typeOfVisit, purposeOfVisit, otherPurposeOfVisit, desiredDateTime1, desiredDateTime2, desiredDAteTime3, phoneNum, verifyPhoneNum, bestTimesForVAtoCall, vaToCallYou, message, sendMeEmail, email  )

      expected_details = [\
        "Request Details",
        "Submitted: " + @today + " @ HH:MM"  + " Location: " + @@facilityName + " Type of Care: " + @@typeOfCare + " Preferred Type of Visit: " + typeOfVisit,
        "Purpose of Visit: " + purposeOfVisit,
        "Preferred Appointment Date/Time",
        "1st Choice: " + desiredDateTime1[0] + " " + desiredDateTime1[1] + " 2nd Choice: " + desiredDateTime2[0] + " " + desiredDateTime2[1] + " 3rd Choice: " + desiredDAteTime3[0] + " " + desiredDAteTime3[1]
      ]

      expected_communicating_with_clerk= [\
          "Message a Scheduling Clerk",
          "You may send up to two (2) messages while this request is in Submitted status. If you need additional information, please call your local VA Medical Center"
      ]

      verifyRequestDetails(expected_details, expected_communicating_with_clerk, @@facilityName)
    end

    it "verify request in list" do
      verifyTableList(@@facilityName, @today, @@typeOfCare)
    end

    it "Verify request limit is reached message" do
      @common.selectAddAppointmentButton("VA")
      @new_request.selectTypeOfCare(MENTAL_HEALTH)
      @new_request.selectState("523")
      @new_request.selectLocation("523")

      expected_content =[\
                        "Step 4: Scheduling Method",
                        "The location you selected supports the following scheduling methods:",
                        "* Select a scheduling method:",
                        "Schedule Myself",
                        "Submit a Request to VA Scheduler",
                        "You have reached the limit of 2 #{MENTAL_HEALTH} request(s).",
                        "In order to proceed, please cancel a pending request, or wait for the VA to process a request."
      ]

      actual_content = @new_request.scheduling_method_section.split("\n")
      compareContents(expected_content, actual_content)

    end
  end
end





